/*
 * Decompiled with CFR 0.152.
 */
package mekanism.client.gui.element.tab.window;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import mekanism.client.SpecialColors;
import mekanism.client.gui.IGuiWrapper;
import mekanism.client.gui.element.tab.window.GuiWindowCreatorTab;
import mekanism.client.gui.element.window.GuiCraftingWindow;
import mekanism.client.gui.element.window.GuiWindow;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.MekanismLang;
import mekanism.common.inventory.container.QIOItemViewerContainer;
import mekanism.common.util.MekanismUtils;
import net.minecraft.network.chat.Component;

public class GuiCraftingWindowTab
extends GuiWindowCreatorTab<Void, GuiCraftingWindowTab> {
    private final boolean[] openWindows = new boolean[3];
    private final QIOItemViewerContainer container;
    private byte currentWindows;

    public GuiCraftingWindowTab(IGuiWrapper gui, Supplier<GuiCraftingWindowTab> elementSupplier, QIOItemViewerContainer container) {
        super(MekanismUtils.getResource(MekanismUtils.ResourceType.GUI_BUTTON, "crafting.png"), gui, null, -26, 34, 26, 18, true, elementSupplier);
        this.container = container;
    }

    @Override
    public void m_7428_(@Nonnull PoseStack matrix, int mouseX, int mouseY) {
        super.m_7428_(matrix, mouseX, mouseY);
        this.displayTooltips(matrix, mouseX, mouseY, new Component[]{MekanismLang.CRAFTING_TAB.translate(this.currentWindows, (byte)3)});
    }

    @Override
    protected void colorTab() {
        MekanismRenderer.color(SpecialColors.TAB_CRAFTING_WINDOW.get());
    }

    @Override
    protected Consumer<GuiWindow> getCloseListener() {
        return window -> {
            GuiCraftingWindowTab tab = (GuiCraftingWindowTab)this.getElementSupplier().get();
            if (window instanceof GuiCraftingWindow) {
                GuiCraftingWindow craftingWindow = (GuiCraftingWindow)window;
                tab.openWindows[craftingWindow.getIndex()] = false;
            }
            tab.currentWindows = (byte)(tab.currentWindows - 1);
            if (tab.currentWindows < 3) {
                tab.f_93623_ = true;
            }
        };
    }

    @Override
    protected Consumer<GuiWindow> getReAttachListener() {
        return super.getReAttachListener().andThen(window -> {
            if (window instanceof GuiCraftingWindow) {
                GuiCraftingWindow craftingWindow = (GuiCraftingWindow)window;
                GuiCraftingWindowTab tab = (GuiCraftingWindowTab)this.getElementSupplier().get();
                tab.openWindows[craftingWindow.getIndex()] = true;
            }
        });
    }

    @Override
    protected void disableTab() {
        this.currentWindows = (byte)(this.currentWindows + 1);
        if (this.currentWindows >= 3) {
            super.disableTab();
        }
    }

    @Override
    protected GuiWindow createWindow() {
        byte index = 0;
        for (int i = 0; i < this.openWindows.length; ++i) {
            if (this.openWindows[i]) continue;
            index = (byte)i;
            break;
        }
        this.openWindows[index] = true;
        return new GuiCraftingWindow(this.gui(), this.getGuiWidth() / 2 - 78, 15, this.container, index);
    }
}

